using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywoanie programu: Program katalog");
      return;
    }
    String katalog = args[0];

    DirectoryInfo di = new DirectoryInfo(katalog);

    if(!di.Exists)
    {
      Console.WriteLine("Katalog {0} nie istnieje", katalog);
      return;
    }
    Console.WriteLine("Dane o katalogu {0}: ", katalog);
    Console.WriteLine("Atrybuty: {0}", di.Attributes);
    Console.WriteLine("Katalog nadrzdny: {0}", di.Parent);
    Console.WriteLine("Rozszerzenie: {0}", di.Extension);
    Console.WriteLine("cieka: {0}", di.FullName);
    Console.WriteLine("Data utworzenia: {0}", di.CreationTime);
    Console.WriteLine("Data ostatniej modyfikacji: {0}", di.LastWriteTime);
    Console.WriteLine("Data ostatniego dostpu: {0}", di.LastAccessTime);
  }
}
